import pandas as pd   
import pickle
import matplotlib.pyplot as plt

# Load the dataset
laptops_price = pd.read_csv("laptops_price.csv")

# Filter the powerful laptops for Windows and macOS operating systems
potential_laptops = powerful_laptops[(powerful_laptops['Operating System'] == 'Windows') | (powerful_laptops['Operating System'] == 'macOS')]
  
# Count the number of laptops by operating system
os_counts = potential_laptops['Operating System'].value_counts()
  
# Create a pie chart of the distribution of operating systems among the potential laptop options
plt.figure(figsize=(8, 8))
os_counts.plot(kind='pie', autopct='%1.1f%%')
plt.title('Distribution of Operating Systems among Potential Laptop Options')
plt.ylabel('')  # Remove the y-axis label
plt.legend(title='Operating System', bbox_to_anchor=(1, 1), loc='upper left')

plt.savefig('./ref_result/pie_chart.png')
plt.show()

print(potential_laptops)
pickle.dump(potential_laptops,open("./ref_result/potential_laptops.pkl","wb"))
